/*----------------------------------------------------------------------------*/
/* @brief 	: Read EEPROM													  *
 * @param	:																  *
 * @retval  :																  */
/*----------------------------------------------------------------------------*/
#include "EEPROM.h"

unsigned char Read_EEPROM(unsigned char addr)
{
	u8 rdata,tm_emi;

	tm_emi = _emi;
	_emi = 0;
	_eea = addr;
//	_mp1h = 1;
//	_mp1l = 0x40;
    _mp1  = 0x40;
    _bp   = 0x01;
	_iar1 |=0x2;				//enable RDEN
	_iar1 |=0x1;				//active READ 
	while((_iar1 & 0x01) !=0);  //wait read end
	rdata = _eed;
	_iar1 &=	0xfD;		    //disable RDEN	
	_emi = tm_emi;
	return (rdata);
}

/*----------------------------------------------------------------------------*/
/* @brief 	: Write EEPROM													  *
 * @param	:																  *
 * @retval  :																  */
/*----------------------------------------------------------------------------*/
void Write_EEPROM(unsigned char addr,unsigned char data)
{
	u8 tm_emi;
	tm_emi = _emi;
	_emi = 0;	
	_eea = addr;
	_eed = data;
//	_mp1h = 1;
//	_mp1l = 0x40;
	_mp1  = 0x40;
	_bp   = 0x01;
	_iar1	|=	0x8;				//enable WREN
	_iar1	|=	0x4;				//active write 
	GCC_NOP();
	while((_iar1 & 0x04) !=0);		//wait write end
	_iar1	&=	0xf7;				//disable WREN	
	_emi = tm_emi;	
}

/*----------------------------------------------------------------------------*/
/* @brief 	: Clear Mac Address												  *
 * @param	:																  *
 * @retval  :																  */
/*----------------------------------------------------------------------------*/
void ClearMacAddr(void)
{   
	int i;
	for(i=0;i<7;i++)
	{
	   Write_EEPROM(0x00,0xFF);
	}
}

/*----------------------------------------------------------------------------*/
/* @brief 	: Write Mac Address	and checksum to EEPROM									  *
 * @param	:																  *
 * @retval  :																  */
/*----------------------------------------------------------------------------*/
void WriteMacAddr(u8 *addr)
{   
	int i;
	for(i=0;i<6;i++)
	{
	   Write_EEPROM(i,addr[i]);
	}
	Write_EEPROM(6,addr[0] + addr[1] + addr[2]+ addr[3] + addr[4] + addr[5]);//checksum
}


/*----------------------------------------------------------------------------*/
/* @brief 	: Read Mac Address and checksum	form EEPROM									  *
 * @param	:																  *
 * @retval  :																  */
/*----------------------------------------------------------------------------*/
void ReadMacAddr(u8 *addr)
{   
	int i;
	u8  temp;
	for(i=0;i<7;i++)
	{
	   addr[i] = Read_EEPROM(i);
	}
	temp = addr[0] + addr[1] + addr[2] + addr[3] + addr[4] + addr[5];
	if(addr[6] != temp)//If the data is wrong
	{
		for(i=0;i<6;i++)
		{
			addr[i] = 0xFF;//Back to defalut value
		}
		ClearMacAddr();
	}		
}
